import type { CapacityConfig, SessionMapping, SpawnDecision, WindowState } from './types';
/**
 * Extended capacity config that includes maxPanes limit
 */
export interface ExtendedCapacityConfig extends CapacityConfig {
    maxPanes?: number;
}
/**
 * Decide what actions to take to spawn a new agent pane
 *
 * Respects maxPanes limit with LRU rotation:
 * - If current agent panes >= maxPanes, close oldest pane before spawning new one
 * - This implements LRU (Least Recently Used) rotation
 */
export declare function decideSpawnActions(state: WindowState, sessionId: string, description: string, config: ExtendedCapacityConfig, sessionMappings: SessionMapping[]): SpawnDecision;
/**
 * Calculate grid capacity based on window size
 */
export declare function calculateCapacity(windowWidth: number, windowHeight: number): {
    cols: number;
    rows: number;
    total: number;
};
//# sourceMappingURL=decision-engine.d.ts.map