import yaml from 'yaml';
export function parseFrontmatter(content) {
    const match = content.match(/^---\r?\n([\s\S]*?)\r?\n---/);
    if (!match) {
        return { data: {}, body: content.trim() };
    }
    const frontmatter = match[1] ?? '';
    const body = content.slice(match[0].length).trim();
    try {
        const data = yaml.parse(frontmatter);
        return { data: (data ?? {}), body };
    }
    catch {
        return { data: {}, body: content.trim() };
    }
}
//# sourceMappingURL=frontmatter.js.map