import type { Client, ClientOptions } from './types';
/**
 * Create a type-safe API client from a RouteRegistry.
 *
 * Uses a Proxy to build up the path as you navigate the object,
 * then executes the request when you call a terminal method (.post(), .get(), .websocket(), etc.).
 *
 * @example
 * ```typescript
 * import { createClient } from '@agentuity/frontend';
 * import type { RPCRouteRegistry } from './generated/routes';
 *
 * const client = createClient<RPCRouteRegistry>();
 *
 * // Type-safe API call
 * const result = await client.hello.post({ name: 'World' });
 *
 * // WebSocket
 * const ws = client.chat.websocket();
 * ws.on('message', (msg) => console.log(msg));
 *
 * // Server-Sent Events
 * const es = client.events.eventstream();
 * es.on('message', (event) => console.log(event.data));
 *
 * // Streaming response
 * const stream = await client.data.stream({ query: 'foo' });
 * stream.on('chunk', (chunk) => console.log(chunk));
 * ```
 */
export declare function createClient<R>(options?: ClientOptions, metadata?: unknown): Client<R>;
export type { ClientOptions, Client, RouteEndpoint, WebSocketClient, EventStreamClient, StreamClient, EventHandler, } from './types';
//# sourceMappingURL=index.d.ts.map