import { z } from 'zod';
export const SessionStartEventSchema = z
    .object({
    id: z.string().describe('the session id'),
    threadId: z.string().optional().describe('the thread id (optional, can be set in complete)'),
    orgId: z.string().describe('the organization id'),
    projectId: z.string().describe('the project id'),
    deploymentId: z.string().optional().describe('the deployment id'),
    routeId: z.string().describe('the route id'),
    environment: z.string().describe('the environment (AGENTUITY_ENVIRONMENT)'),
    devmode: z.boolean().describe('true if running in devmode'),
    url: z.string().describe('the url for the session event'),
    method: z.string().describe('the method for the session event'),
    trigger: z
        .enum(['agent', 'api', 'email', 'sms', 'cron', 'manual', 'discord', 'websocket'])
        .describe('how the session was triggered'),
    metadata: z
        .record(z.string(), z.unknown())
        .optional()
        .describe('optional unencrypted key-value metadata'),
})
    .describe('The event to record a session started');
export const SessionCompleteEventSchema = z
    .object({
    id: z.string().describe('the session id'),
    threadId: z.string().nullable().describe('the thread id (null if thread has no data)'),
    error: z.string().optional().describe('the optional error message if the session failed'),
    agentIds: z
        .array(z.string())
        .optional()
        .describe('optional array of ids for the agents that executed for the session'),
    statusCode: z.number().describe('the HTTP status code'),
    userData: z.string().optional().describe('optional JSON string of session state data'),
    metadata: z
        .record(z.string(), z.unknown())
        .optional()
        .describe('optional unencrypted key-value metadata'),
})
    .describe('The event to record a session completed successfully');
export const SessionStartEventDelayedSchema = z.intersection(SessionStartEventSchema, z.object({ timestamp: z.number().int().describe('the event timestamp in epoch') }));
export const SessionCompleteEventDelayedSchema = z.intersection(SessionCompleteEventSchema, z.object({ timestamp: z.number().int().describe('the event timestamp in epoch') }));
//# sourceMappingURL=session.js.map