import { semver } from 'bun';

const MIN_BUN_VERSION = '>=1.3.3';
const MIN_GRAVITY_VERSION = '>=1.0.6';

export function isBun(): boolean {
	return typeof Bun !== 'undefined';
}

/**
 * Validate if you're running a compatible minimum version of Bun
 */
export function validateRuntime(): void {
	if (!isBun()) {
		console.error('Error: This CLI requires Bun runtime');
		console.error('Please install Bun: https://bun.sh');
		process.exit(1);
	}

	const bunVersion = Bun.version;
	if (semver.satisfies(bunVersion, MIN_BUN_VERSION) === false) {
		console.error(`Error: This CLI requires Bun ${MIN_BUN_VERSION}`);
		console.error(`Current Bun version: ${bunVersion}`);
		process.exit(1);
	}
}

/**
 * Returns true if the gravity binary requires an upgrade
 *
 * @param version current version
 * @returns
 */
export function validateGravityRequiresUpgrade(version: string): boolean {
	return semver.satisfies(version, MIN_GRAVITY_VERSION) === false;
}
