/**
 * npm registry availability checking utilities.
 * Used to verify a version is available on npm before attempting upgrade.
 */
export interface CheckNpmOptions {
    /** Timeout in milliseconds (default: 5000 for explicit, 1000 for quick) */
    timeoutMs?: number;
}
/**
 * Check if a specific version of @agentuity/cli is available on npm registry.
 * Uses the npm registry API directly for faster response than `npm view`.
 *
 * @param version - Version to check (with or without 'v' prefix)
 * @param options - Optional configuration
 * @returns true if version is available, false otherwise
 */
export declare function isVersionAvailableOnNpm(version: string, options?: CheckNpmOptions): Promise<boolean>;
/**
 * Quick check if a version is available on npm with a short timeout.
 * Used for implicit version checks (auto-upgrade flow) to avoid blocking the user's command.
 *
 * @param version - Version to check (with or without 'v' prefix)
 * @returns true if version is available, false if unavailable or timeout
 */
export declare function isVersionAvailableOnNpmQuick(version: string): Promise<boolean>;
export interface WaitForNpmOptions {
    /** Maximum number of attempts (default: 6) */
    maxAttempts?: number;
    /** Initial delay between attempts in ms (default: 2000) */
    initialDelayMs?: number;
    /** Maximum delay between attempts in ms (default: 10000) */
    maxDelayMs?: number;
    /** Callback called before each retry */
    onRetry?: (attempt: number, delayMs: number) => void;
}
/**
 * Wait for a version to become available on npm with exponential backoff.
 *
 * @param version - Version to wait for (with or without 'v' prefix)
 * @param options - Configuration options
 * @returns true if version became available, false if timed out
 */
export declare function waitForNpmAvailability(version: string, options?: WaitForNpmOptions): Promise<boolean>;
//# sourceMappingURL=npm-availability.d.ts.map