import { type Config } from '../../types';
import type { APIClient } from '../../api';
import type { Logger } from '@agentuity/core';
export interface DetectedGitInfo {
    repo: string | null;
    branch: string | null;
}
export declare function detectGitInfo(): DetectedGitInfo;
export interface RunGitLinkOptions {
    apiClient: APIClient;
    projectId: string;
    orgId: string;
    logger: Logger;
    branchOption?: string;
    rootOption?: string;
    noAuto?: boolean;
    noPreview?: boolean;
    skipAlreadyLinkedCheck?: boolean;
    config?: Config | null;
}
export interface RunGitLinkResult {
    linked: boolean;
    repoFullName?: string;
    branch?: string;
    autoDeploy?: boolean;
    cancelled?: boolean;
    noGithubConnected?: boolean;
    noReposFound?: boolean;
}
export declare function runGitLink(options: RunGitLinkOptions): Promise<RunGitLinkResult>;
export declare const linkSubcommand: import("../..").SubcommandDefinition;
//# sourceMappingURL=link.d.ts.map