/**
 * Registry Generator
 *
 * Generates src/generated/registry.ts from discovered agents
 */
import type { AgentMetadata } from './agent-discovery';
import type { RouteInfo } from './route-discovery';
/**
 * Generate src/generated/registry.ts with agent registry and types
 */
export declare function generateAgentRegistry(srcDir: string, agents: AgentMetadata[]): void;
/**
 * Generate RouteRegistry type definitions from discovered routes.
 *
 * Creates a module augmentation for @agentuity/react that provides
 * strongly-typed route keys with input/output schema information.
 */
export declare function generateRouteRegistry(srcDir: string, routes: RouteInfo[], agents?: AgentMetadata[]): Promise<void>;
//# sourceMappingURL=registry-generator.d.ts.map