import type { Project } from '@agentuity/server';
/**
 * Get a cached project by profile and project ID.
 * Returns null if not found in cache.
 */
export declare function getCachedProject(profile: string, projectId: string): Project | null;
/**
 * Store a project in the cache.
 */
export declare function setCachedProject(profile: string, projectId: string, project: Project): void;
/**
 * Clear all cached projects.
 * Useful for testing or when switching contexts.
 */
export declare function clearProjectCache(): void;
//# sourceMappingURL=project-cache.d.ts.map