/**
 * Check if running inside a tmux session
 */
export declare function isInsideTmux(): boolean;
/**
 * Get the current pane ID
 */
export declare function getCurrentPaneId(): string | undefined;
/**
 * Get the path to the tmux binary
 */
export declare function getTmuxPath(): Promise<string | null>;
/**
 * Run a tmux command and return output
 */
export declare function runTmuxCommand(args: string[]): Promise<{
    success: boolean;
    output: string;
}>;
/**
 * Run a tmux command synchronously (for shutdown scenarios)
 * Uses spawnSync to ensure completion before process exit
 */
export declare function runTmuxCommandSync(args: string[]): {
    success: boolean;
    output: string;
};
/**
 * Get the path to the tmux binary synchronously
 */
export declare function getTmuxPathSync(): string | null;
/**
 * Get the tmux session ID for a given pane.
 * This is used to ensure windows are created in the correct tmux session
 * when multiple opencode instances run in different sessions.
 */
export declare function getTmuxSessionId(paneId: string): Promise<string | undefined>;
/**
 * Get the tmux session ID synchronously (for shutdown scenarios)
 */
export declare function getTmuxSessionIdSync(paneId: string): string | undefined;
/**
 * Canonicalize server URL for consistent ownership tagging.
 * Normalizes loopback addresses (127.0.0.1, ::1) to localhost.
 *
 * @throws Error if URL is invalid
 */
export declare function canonicalizeServerUrl(url: string): string;
//# sourceMappingURL=utils.d.ts.map