export interface ConfigWarning {
    agent: string;
    message: string;
}
/**
 * Minimal config shape for validation - works with both AgentConfig and AgentModelConfig.
 */
interface ValidatableConfig {
    model?: string;
    reasoningEffort?: string;
    variant?: string;
    thinking?: unknown;
}
/**
 * Validates agent model configuration and returns warnings for mismatches.
 * Does not throw - just warns about potentially incorrect configuration.
 */
export declare function validateAgentConfig(agentName: string, config: ValidatableConfig): ConfigWarning[];
/**
 * Validates all agent configs and logs warnings.
 */
export declare function validateAndWarnConfigs(configs: Record<string, ValidatableConfig>, logger?: {
    warn: (msg: string) => void;
}): void;
export {};
//# sourceMappingURL=validation.d.ts.map