export type BackgroundTaskStatus = 'pending' | 'running' | 'completed' | 'error' | 'cancelled';
export interface TaskProgress {
    toolCalls: number;
    lastTool?: string;
    lastUpdate: Date;
    lastMessage?: string;
    lastMessageAt?: Date;
}
export interface BackgroundTask {
    id: string;
    sessionId?: string;
    parentSessionId: string;
    parentMessageId?: string;
    description: string;
    prompt: string;
    agent: string;
    status: BackgroundTaskStatus;
    queuedAt?: Date;
    startedAt?: Date;
    completedAt?: Date;
    result?: string;
    error?: string;
    progress?: TaskProgress;
    concurrencyKey?: string;
    concurrencyGroup?: string;
}
export interface LaunchInput {
    description: string;
    prompt: string;
    agent: string;
    parentSessionId: string;
    parentMessageId?: string;
}
export interface ResumeInput {
    sessionId: string;
    prompt: string;
    parentSessionId: string;
    parentMessageId?: string;
}
export interface BackgroundTaskConfig {
    enabled: boolean;
    defaultConcurrency: number;
    staleTimeoutMs: number;
    providerConcurrency?: Record<string, number>;
    modelConcurrency?: Record<string, number>;
}
//# sourceMappingURL=types.d.ts.map