import { leadAgent } from './lead';
import { scoutAgent } from './scout';
import { builderAgent } from './builder';
import { architectAgent } from './architect';
import { reviewerAgent } from './reviewer';
import { memoryAgent } from './memory';
import { expertAgent } from './expert';
import { plannerAgent } from './planner';
import { runnerAgent } from './runner';
import { reasonerAgent } from './reasoner';
import { productAgent } from './product';
export const agents = {
    lead: leadAgent,
    scout: scoutAgent,
    builder: builderAgent,
    architect: architectAgent,
    reviewer: reviewerAgent,
    memory: memoryAgent,
    expert: expertAgent,
    planner: plannerAgent,
    runner: runnerAgent,
    reasoner: reasonerAgent,
    product: productAgent,
};
export function getAgent(role) {
    return agents[role];
}
export function getAgentByRole(role) {
    return agents[role];
}
export function getAgentById(id) {
    return Object.values(agents).find((a) => a.id === id);
}
export function getAllAgents() {
    return Object.values(agents);
}
export function createAgentRegistry() {
    return {
        get(role) {
            return agents[role];
        },
        getAll() {
            return Object.values(agents);
        },
        has(role) {
            return role in agents;
        },
    };
}
//# sourceMappingURL=index.js.map