import { type BaseEvalOptions } from './types';
export declare const formatPrompt = "You are evaluating whether an LLM response matches the format requested by the user.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a strict validator checking format compliance.\n2. Identify any explicit format requirements in the USER REQUEST, including:\n   - Structured data formats: JSON, XML, YAML, CSV, etc.\n   - Document formats: Markdown, plain text, HTML, etc.\n   - List formats: Bullet points, numbered lists, comma-separated, etc.\n   - Table formats: Markdown tables, ASCII tables, etc.\n   - Code formats: Specific programming language, code blocks, etc.\n   - Length constraints: Word counts, character limits, number of items, etc.\n   - Structural requirements: Sections, headers, specific fields, etc.\n3. If no format is explicitly requested, this eval automatically passes.\n4. If a format is requested, verify the MODEL RESPONSE strictly adheres to it:\n   - JSON must be valid, parseable JSON\n   - Lists must use the specified list style\n   - Tables must have proper structure\n   - Code must be in the specified language and properly formatted\n   - Length constraints must be met exactly or within stated tolerance\n\n## Pass/Fail\n\n- passed = true only if no format was requested OR the response strictly matches all requested format requirements.\n- passed = false if any format requirement is violated, even partially.\n\n## Constraints\n\n- Do not assume implicit format preferences; only enforce explicit requests.\n- Do not credit \"close enough\" formatting; requirements must be met exactly.\n- Do not excuse format violations because the content is otherwise correct.\n- Do not pass responses that wrap requested format in additional commentary unless explicitly allowed.\n- JSON responses with syntax errors (trailing commas, unquoted keys, etc.) are failures.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence stating format requirement and whether it was met, or confirming no format was requested>\"\n}";
export declare const format: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
    onStart?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any) => void | Promise<void>) | undefined;
    onComplete?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, result: import("@agentuity/runtime").EvalHandlerResult) => void | Promise<void>) | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: BaseEvalOptions;
};
//# sourceMappingURL=format.d.ts.map