import { type BaseEvalOptions } from './types';
export declare const answerCompletenessPrompt = "You are evaluating whether an LLM response directly addresses the user's request.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a strict auditor who expects every part of the user's request to be addressed.\n2. Identify each distinct question, instruction, or requirement in the USER REQUEST.\n3. For each identified item, check whether the MODEL RESPONSE provides a direct, relevant answer or fulfillment.\n4. Flag any of the following violations:\n   - Ignoring part of the request entirely\n   - Providing tangential information instead of answering\n   - Deflecting with \"I can't help with that\" without justification\n   - Answering a different question than what was asked\n   - Providing vague or generic responses that do not address specifics\n   - Excessive hedging or caveats that obscure whether the question was answered\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each violation:\n   - Minor omission (small detail or sub-question not addressed): \u22120.2\n   - Partial answer (core question addressed but incompletely): \u22120.3\n   - Tangential response (related content but does not answer the question): \u22120.5\n   - Complete miss (major requirement or question ignored entirely): \u22120.6\n   - Refusal without valid justification: \u22120.8\n- Minimum score is 0.0.\n- Multiple violations compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 0.7 AND no complete misses or unjustified refusals are present.\n\n## Constraints\n\n- Do not credit the response for being correct if it does not address what was asked.\n- Do not credit the response for being helpful on unrelated topics.\n- Do not infer that the user's needs were met unless explicitly addressed in the response.\n- Do not excuse incomplete answers due to response length or complexity.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence listing which parts of the request were or were not addressed>\"\n}";
type AnswerCompletenessEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const answerCompleteness: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
    onStart?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any) => void | Promise<void>) | undefined;
    onComplete?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, result: import("@agentuity/runtime").EvalHandlerResult) => void | Promise<void>) | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: AnswerCompletenessEvalOptions;
};
export {};
//# sourceMappingURL=answer-completeness.d.ts.map