/**
 * Parse duration string (e.g., "1h", "2d", "1y") or ISO date to ISO date string
 *
 * @param input - Duration string (1m, 1h, 2d, 1w, 1y) or ISO date (2025-12-31T23:59:59Z)
 * @returns ISO date string
 * @throws Error if input format is invalid
 *
 * @example
 * parseExpiresAt('1h') // Returns ISO date 1 hour from now
 * parseExpiresAt('30d') // Returns ISO date 30 days from now
 * parseExpiresAt('2025-12-31T23:59:59Z') // Returns same ISO date
 */
export declare function parseExpiresAt(input: string): string;
//# sourceMappingURL=date.d.ts.map