import type { ZodType } from 'zod';
import type { CommandSchemas } from './types';
export interface ParsedArgs {
    names: string[];
    metadata: Array<{
        name: string;
        optional: boolean;
        variadic: boolean;
    }>;
}
export interface ParsedOption {
    name: string;
    description?: string;
    type: 'string' | 'number' | 'boolean' | 'array' | 'optionalString';
    hasDefault?: boolean;
    defaultValue?: unknown;
    enumValues?: string[];
}
export declare function parseArgsSchema(schema: ZodType): ParsedArgs;
export declare function parseOptionsSchema(schema: ZodType): ParsedOption[];
/**
 * Reset stdin confirmation cache (for testing)
 */
export declare function resetStdinConfirmationCache(): void;
export declare function buildValidationInput(schemas: CommandSchemas, rawArgs: unknown[], rawOptions: Record<string, unknown>, _options?: {
    usesStdin?: boolean;
}): {
    args: Record<string, unknown>;
    options: Record<string, unknown>;
};
/**
 * Async version of buildValidationInput that also checks stdin for "yes" confirmation.
 * Use this when the command has a confirm option and doesn't use stdin for other purposes.
 */
export declare function buildValidationInputAsync(schemas: CommandSchemas, rawArgs: unknown[], rawOptions: Record<string, unknown>, options?: {
    usesStdin?: boolean;
}): Promise<{
    args: Record<string, unknown>;
    options: Record<string, unknown>;
}>;
//# sourceMappingURL=schema-parser.d.ts.map