import type { APIClient } from '../../../api';
import type { Config } from '../../../types';
/**
 * Resolves the organization ID for org-scoped env operations.
 *
 * @param apiClient - The API client
 * @param config - The CLI config (may be null)
 * @param orgOption - The --org option value (true for default/prompt, or explicit org ID)
 * @param autoSelect - If true, auto-select preferred org without prompting (for --confirm)
 * @returns The resolved organization ID
 */
export declare function resolveOrgId(apiClient: APIClient, config: Config | null, orgOption: boolean | string, autoSelect?: boolean): Promise<string>;
/**
 * Checks if we're operating in org scope based on the --org option.
 */
export declare function isOrgScope(orgOption: boolean | string | undefined): boolean;
//# sourceMappingURL=org-util.d.ts.map