import { StructuredError } from '@agentuity/core';
const ProjectIDRequiredError = StructuredError('ProjectIDRequiredError', 'Project ID is required. Use --project-id or run from a project directory.');
export function resolveProjectId(ctx, options) {
    if (options.projectId) {
        return options.projectId;
    }
    if (ctx.project?.projectId) {
        return ctx.project.projectId;
    }
    throw new ProjectIDRequiredError();
}
//# sourceMappingURL=utils.js.map